##-------------------------------------------------------------------------------
##--                            Ken Campbell
##--                        No Rights Reserved
##-------------------------------------------------------------------------------
##-- $Author: ken $
##--
##-- $Date: 2005/12/09 15:14:08 $
##--
##-- $Name:  $
##--
##-- $Id: $
##--
##-- $Source: $
##--
##-- Description :
##--      
##------------------------------------------------------------------------------
##-- This software contains concepts 
##-- 
##-- 
##-------------------------------------------------------------------------------
## package requires
package require Iwidgets 4.0

namespace eval e {
    variable row
    variable col
}

set e::row 1
set e::col 1

set r1 [frame .ro1]
set f1 [frame $r1.fr1]
set f10 [frame $f1.fr10]
set f11 [frame $f1.fr11]
set f12 [frame $f1.fr12]

set f2 [frame $r1.fr2]
set f20 [frame $f2.fr20]
set f21 [frame $f2.fr21]
set f22 [frame $f2.fr22]

set f3 [frame $r1.fr3]
set f30 [frame $f3.fr30]
set f31 [frame $f3.fr31]
set f32 [frame $f3.fr32]

set r2 [frame .ro2]
set f4 [frame $r2.fr4]
set f40 [frame $f4.fr40]
set f41 [frame $f4.fr41]
set f42 [frame $f4.fr42]

set f5 [frame $r2.fr5]
set f50 [frame $f5.fr50]
set f51 [frame $f5.fr51]
set f52 [frame $f5.fr52]

set f6 [frame $r2.fr6]
set f60 [frame $f6.fr60]
set f61 [frame $f6.fr61]
set f62 [frame $f6.fr62]

set r3 [frame .ro3]
set f7 [frame $r3.fr7]
set f70 [frame $f7.fr70]
set f71 [frame $f7.fr71]
set f72 [frame $f7.fr72]

set f8 [frame $r3.fr8]
set f80 [frame $f8.fr80]
set f81 [frame $f8.fr81]
set f82 [frame $f8.fr82]

set f9 [frame $r3.fr9]
set f90 [frame $f9.fr90]
set f91 [frame $f9.fr91]
set f92 [frame $f9.fr92]


#set e::i11 [entry $f10.ent1 -width 1 -relief flat -cursor target]
set e::i11 [entry $f10.ent1 -width 1 -validate focusout -vcmd {check_ent $e::i11} -invcmd {inval_ent $e::i11} -font brd_fnt -readonlybackground $dis_col]
set e::i12 [entry $f10.ent2 -width 1 -validate focusout -vcmd {check_ent $e::i12} -invcmd {inval_ent $e::i12} -font brd_fnt -readonlybackground $dis_col]
set e::i13 [entry $f10.ent3 -width 1 -validate focusout -vcmd {check_ent $e::i13} -invcmd {inval_ent $e::i13} -font brd_fnt -readonlybackground $dis_col]

set e::i21 [entry $f11.ent4 -width 1 -validate focusout -vcmd {check_ent $e::i21} -invcmd {inval_ent $e::i21} -font brd_fnt -readonlybackground $dis_col]
set e::i22 [entry $f11.ent5 -width 1 -validate focusout -vcmd {check_ent $e::i22} -invcmd {inval_ent $e::i22} -font brd_fnt -readonlybackground $dis_col]
set e::i23 [entry $f11.ent6 -width 1 -validate focusout -vcmd {check_ent $e::i23} -invcmd {inval_ent $e::i23} -font brd_fnt -readonlybackground $dis_col]

set e::i31 [entry $f12.ent7 -width 1 -validate focusout -vcmd {check_ent $e::i31} -invcmd {inval_ent $e::i31} -font brd_fnt -readonlybackground $dis_col]
set e::i32 [entry $f12.ent8 -width 1 -validate focusout -vcmd {check_ent $e::i32} -invcmd {inval_ent $e::i32} -font brd_fnt -readonlybackground $dis_col]
set e::i33 [entry $f12.ent9 -width 1 -validate focusout -vcmd {check_ent $e::i33} -invcmd {inval_ent $e::i33} -font brd_fnt -readonlybackground $dis_col]

set e::i14 [entry $f20.ent1 -width 1 -validate focusout -vcmd {check_ent $e::i14} -invcmd {inval_ent $e::i14} -font brd_fnt -readonlybackground $dis_col]
set e::i15 [entry $f20.ent2 -width 1 -validate focusout -vcmd {check_ent $e::i15} -invcmd {inval_ent $e::i15} -font brd_fnt -readonlybackground $dis_col]
set e::i16 [entry $f20.ent3 -width 1 -validate focusout -vcmd {check_ent $e::i16} -invcmd {inval_ent $e::i16} -font brd_fnt -readonlybackground $dis_col]

set e::i24 [entry $f21.ent4 -width 1 -validate focusout -vcmd {check_ent $e::i24} -invcmd {inval_ent $e::i24} -font brd_fnt -readonlybackground $dis_col]
set e::i25 [entry $f21.ent5 -width 1 -validate focusout -vcmd {check_ent $e::i25} -invcmd {inval_ent $e::i25} -font brd_fnt -readonlybackground $dis_col]
set e::i26 [entry $f21.ent6 -width 1 -validate focusout -vcmd {check_ent $e::i26} -invcmd {inval_ent $e::i26} -font brd_fnt -readonlybackground $dis_col]

set e::i34 [entry $f22.ent7 -width 1 -validate focusout -vcmd {check_ent $e::i34} -invcmd {inval_ent $e::i34} -font brd_fnt -readonlybackground $dis_col]
set e::i35 [entry $f22.ent8 -width 1 -validate focusout -vcmd {check_ent $e::i35} -invcmd {inval_ent $e::i35} -font brd_fnt -readonlybackground $dis_col]
set e::i36 [entry $f22.ent9 -width 1 -validate focusout -vcmd {check_ent $e::i36} -invcmd {inval_ent $e::i36} -font brd_fnt -readonlybackground $dis_col]

set e::i17 [entry $f30.ent1 -width 1 -validate focusout -vcmd {check_ent $e::i17} -invcmd {inval_ent $e::i17} -font brd_fnt -readonlybackground $dis_col]
set e::i18 [entry $f30.ent2 -width 1 -validate focusout -vcmd {check_ent $e::i18} -invcmd {inval_ent $e::i18} -font brd_fnt -readonlybackground $dis_col]
set e::i19 [entry $f30.ent3 -width 1 -validate focusout -vcmd {check_ent $e::i19} -invcmd {inval_ent $e::i19} -font brd_fnt -readonlybackground $dis_col]

set e::i27 [entry $f31.ent4 -width 1 -validate focusout -vcmd {check_ent $e::i27} -invcmd {inval_ent $e::i27} -font brd_fnt -readonlybackground $dis_col]
set e::i28 [entry $f31.ent5 -width 1 -validate focusout -vcmd {check_ent $e::i28} -invcmd {inval_ent $e::i28} -font brd_fnt -readonlybackground $dis_col]
set e::i29 [entry $f31.ent6 -width 1 -validate focusout -vcmd {check_ent $e::i29} -invcmd {inval_ent $e::i29} -font brd_fnt -readonlybackground $dis_col]

set e::i37 [entry $f32.ent7 -width 1 -validate focusout -vcmd {check_ent $e::i37} -invcmd {inval_ent $e::i37} -font brd_fnt -readonlybackground $dis_col]
set e::i38 [entry $f32.ent8 -width 1 -validate focusout -vcmd {check_ent $e::i38} -invcmd {inval_ent $e::i38} -font brd_fnt -readonlybackground $dis_col]
set e::i39 [entry $f32.ent9 -width 1 -validate focusout -vcmd {check_ent $e::i39} -invcmd {inval_ent $e::i39} -font brd_fnt -readonlybackground $dis_col]

set e::i41 [entry $f40.ent1 -width 1 -validate focusout -vcmd {check_ent $e::i41} -invcmd {inval_ent $e::i41} -font brd_fnt -readonlybackground $dis_col]
set e::i42 [entry $f40.ent2 -width 1 -validate focusout -vcmd {check_ent $e::i42} -invcmd {inval_ent $e::i42} -font brd_fnt -readonlybackground $dis_col]
set e::i43 [entry $f40.ent3 -width 1 -validate focusout -vcmd {check_ent $e::i43} -invcmd {inval_ent $e::i43} -font brd_fnt -readonlybackground $dis_col]

set e::i51 [entry $f41.ent4 -width 1 -validate focusout -vcmd {check_ent $e::i51} -invcmd {inval_ent $e::i51} -font brd_fnt -readonlybackground $dis_col]
set e::i52 [entry $f41.ent5 -width 1 -validate focusout -vcmd {check_ent $e::i52} -invcmd {inval_ent $e::i52} -font brd_fnt -readonlybackground $dis_col]
set e::i53 [entry $f41.ent6 -width 1 -validate focusout -vcmd {check_ent $e::i53} -invcmd {inval_ent $e::i53} -font brd_fnt -readonlybackground $dis_col]

set e::i61 [entry $f42.ent7 -width 1 -validate focusout -vcmd {check_ent $e::i61} -invcmd {inval_ent $e::i61} -font brd_fnt -readonlybackground $dis_col]
set e::i62 [entry $f42.ent8 -width 1 -validate focusout -vcmd {check_ent $e::i62} -invcmd {inval_ent $e::i62} -font brd_fnt -readonlybackground $dis_col]
set e::i63 [entry $f42.ent9 -width 1 -validate focusout -vcmd {check_ent $e::i63} -invcmd {inval_ent $e::i63} -font brd_fnt -readonlybackground $dis_col]

set e::i44 [entry $f50.ent1 -width 1 -validate focusout -vcmd {check_ent $e::i44} -invcmd {inval_ent $e::i44} -font brd_fnt -readonlybackground $dis_col]
set e::i45 [entry $f50.ent2 -width 1 -validate focusout -vcmd {check_ent $e::i45} -invcmd {inval_ent $e::i45} -font brd_fnt -readonlybackground $dis_col]
set e::i46 [entry $f50.ent3 -width 1 -validate focusout -vcmd {check_ent $e::i46} -invcmd {inval_ent $e::i46} -font brd_fnt -readonlybackground $dis_col]

set e::i54 [entry $f51.ent4 -width 1 -validate focusout -vcmd {check_ent $e::i54} -invcmd {inval_ent $e::i54} -font brd_fnt -readonlybackground $dis_col]
set e::i55 [entry $f51.ent5 -width 1 -validate focusout -vcmd {check_ent $e::i55} -invcmd {inval_ent $e::i55} -font brd_fnt -readonlybackground $dis_col]
set e::i56 [entry $f51.ent6 -width 1 -validate focusout -vcmd {check_ent $e::i56} -invcmd {inval_ent $e::i56} -font brd_fnt -readonlybackground $dis_col]

set e::i64 [entry $f52.ent7 -width 1 -validate focusout -vcmd {check_ent $e::i64} -invcmd {inval_ent $e::i64} -font brd_fnt -readonlybackground $dis_col]
set e::i65 [entry $f52.ent8 -width 1 -validate focusout -vcmd {check_ent $e::i65} -invcmd {inval_ent $e::i65} -font brd_fnt -readonlybackground $dis_col]
set e::i66 [entry $f52.ent9 -width 1 -validate focusout -vcmd {check_ent $e::i66} -invcmd {inval_ent $e::i66} -font brd_fnt -readonlybackground $dis_col]

set e::i47 [entry $f60.ent1 -width 1 -validate focusout -vcmd {check_ent $e::i47} -invcmd {inval_ent $e::i47} -font brd_fnt -readonlybackground $dis_col]
set e::i48 [entry $f60.ent2 -width 1 -validate focusout -vcmd {check_ent $e::i48} -invcmd {inval_ent $e::i48} -font brd_fnt -readonlybackground $dis_col]
set e::i49 [entry $f60.ent3 -width 1 -validate focusout -vcmd {check_ent $e::i49} -invcmd {inval_ent $e::i49} -font brd_fnt -readonlybackground $dis_col]

set e::i57 [entry $f61.ent4 -width 1 -validate focusout -vcmd {check_ent $e::i57} -invcmd {inval_ent $e::i57} -font brd_fnt -readonlybackground $dis_col]
set e::i58 [entry $f61.ent5 -width 1 -validate focusout -vcmd {check_ent $e::i58} -invcmd {inval_ent $e::i58} -font brd_fnt -readonlybackground $dis_col]
set e::i59 [entry $f61.ent6 -width 1 -validate focusout -vcmd {check_ent $e::i59} -invcmd {inval_ent $e::i59} -font brd_fnt -readonlybackground $dis_col]

set e::i67 [entry $f62.ent7 -width 1 -validate focusout -vcmd {check_ent $e::i67} -invcmd {inval_ent $e::i67} -font brd_fnt -readonlybackground $dis_col]
set e::i68 [entry $f62.ent8 -width 1 -validate focusout -vcmd {check_ent $e::i68} -invcmd {inval_ent $e::i68} -font brd_fnt -readonlybackground $dis_col]
set e::i69 [entry $f62.ent9 -width 1 -validate focusout -vcmd {check_ent $e::i69} -invcmd {inval_ent $e::i69} -font brd_fnt -readonlybackground $dis_col]

set e::i71 [entry $f70.ent1 -width 1 -validate focusout -vcmd {check_ent $e::i71} -invcmd {inval_ent $e::i71} -font brd_fnt -readonlybackground $dis_col]
set e::i72 [entry $f70.ent2 -width 1 -validate focusout -vcmd {check_ent $e::i72} -invcmd {inval_ent $e::i72} -font brd_fnt -readonlybackground $dis_col]
set e::i73 [entry $f70.ent3 -width 1 -validate focusout -vcmd {check_ent $e::i73} -invcmd {inval_ent $e::i73} -font brd_fnt -readonlybackground $dis_col]

set e::i81 [entry $f71.ent4 -width 1 -validate focusout -vcmd {check_ent $e::i81} -invcmd {inval_ent $e::i81} -font brd_fnt -readonlybackground $dis_col]
set e::i82 [entry $f71.ent5 -width 1 -validate focusout -vcmd {check_ent $e::i82} -invcmd {inval_ent $e::i82} -font brd_fnt -readonlybackground $dis_col]
set e::i83 [entry $f71.ent6 -width 1 -validate focusout -vcmd {check_ent $e::i83} -invcmd {inval_ent $e::i83} -font brd_fnt -readonlybackground $dis_col]

set e::i91 [entry $f72.ent7 -width 1 -validate focusout -vcmd {check_ent $e::i91} -invcmd {inval_ent $e::i91} -font brd_fnt -readonlybackground $dis_col]
set e::i92 [entry $f72.ent8 -width 1 -validate focusout -vcmd {check_ent $e::i92} -invcmd {inval_ent $e::i92} -font brd_fnt -readonlybackground $dis_col]
set e::i93 [entry $f72.ent9 -width 1 -validate focusout -vcmd {check_ent $e::i93} -invcmd {inval_ent $e::i93} -font brd_fnt -readonlybackground $dis_col]

set e::i74 [entry $f80.ent1 -width 1 -validate focusout -vcmd {check_ent $e::i74} -invcmd {inval_ent $e::i74} -font brd_fnt -readonlybackground $dis_col]
set e::i75 [entry $f80.ent2 -width 1 -validate focusout -vcmd {check_ent $e::i75} -invcmd {inval_ent $e::i75} -font brd_fnt -readonlybackground $dis_col]
set e::i76 [entry $f80.ent3 -width 1 -validate focusout -vcmd {check_ent $e::i76} -invcmd {inval_ent $e::i76} -font brd_fnt -readonlybackground $dis_col]

set e::i84 [entry $f81.ent4 -width 1 -validate focusout -vcmd {check_ent $e::i84} -invcmd {inval_ent $e::i84} -font brd_fnt -readonlybackground $dis_col]
set e::i85 [entry $f81.ent5 -width 1 -validate focusout -vcmd {check_ent $e::i85} -invcmd {inval_ent $e::i85} -font brd_fnt -readonlybackground $dis_col]
set e::i86 [entry $f81.ent6 -width 1 -validate focusout -vcmd {check_ent $e::i86} -invcmd {inval_ent $e::i86} -font brd_fnt -readonlybackground $dis_col]

set e::i94 [entry $f82.ent7 -width 1 -validate focusout -vcmd {check_ent $e::i94} -invcmd {inval_ent $e::i94} -font brd_fnt -readonlybackground $dis_col]
set e::i95 [entry $f82.ent8 -width 1 -validate focusout -vcmd {check_ent $e::i95} -invcmd {inval_ent $e::i95} -font brd_fnt -readonlybackground $dis_col]
set e::i96 [entry $f82.ent9 -width 1 -validate focusout -vcmd {check_ent $e::i96} -invcmd {inval_ent $e::i96} -font brd_fnt -readonlybackground $dis_col]

set e::i77 [entry $f90.ent1 -width 1 -validate focusout -vcmd {check_ent $e::i77} -invcmd {inval_ent $e::i77} -font brd_fnt -readonlybackground $dis_col]
set e::i78 [entry $f90.ent2 -width 1 -validate focusout -vcmd {check_ent $e::i78} -invcmd {inval_ent $e::i78} -font brd_fnt -readonlybackground $dis_col]
set e::i79 [entry $f90.ent3 -width 1 -validate focusout -vcmd {check_ent $e::i79} -invcmd {inval_ent $e::i79} -font brd_fnt -readonlybackground $dis_col]

set e::i87 [entry $f91.ent4 -width 1 -validate focusout -vcmd {check_ent $e::i87} -invcmd {inval_ent $e::i87} -font brd_fnt -readonlybackground $dis_col]
set e::i88 [entry $f91.ent5 -width 1 -validate focusout -vcmd {check_ent $e::i88} -invcmd {inval_ent $e::i88} -font brd_fnt -readonlybackground $dis_col]
set e::i89 [entry $f91.ent6 -width 1 -validate focusout -vcmd {check_ent $e::i89} -invcmd {inval_ent $e::i89} -font brd_fnt -readonlybackground $dis_col]

set e::i97 [entry $f92.ent7 -width 1 -validate focusout -vcmd {check_ent $e::i97} -invcmd {inval_ent $e::i97} -font brd_fnt -readonlybackground $dis_col]
set e::i98 [entry $f92.ent8 -width 1 -validate focusout -vcmd {check_ent $e::i98} -invcmd {inval_ent $e::i98} -font brd_fnt -readonlybackground $dis_col]
set e::i99 [entry $f92.ent9 -width 1 -validate focusout -vcmd {check_ent $e::i99} -invcmd {inval_ent $e::i99} -font brd_fnt -readonlybackground $dis_col]


set menu_frame [frame .mfr]

###   menu bar
set mbar [iwidgets::menubar $menu_frame.mb -helpvariable usr_txt -menubuttons {
    menubutton xmdg -text "Options" -menu {
        options -tearoff false
        command setefforhi -label "Highest Effort Level" \
            -helpstr "I will try really hard!!" \
            -command {set effort_level 2500}
        command setefformed -label "Medium Effort Level" \
            -helpstr "I will try" \
            -command {set effort_level 1200}
        command setefforlo -label "Low Effort Level" \
            -helpstr "I will not waste your time!" \
            -command {set effort_level 600}
        command colorset -label "Change Colors" \
            -helpstr "Change the Shown Background" \
            -command {pick_color}
##        command colorsetbg -label "Change Background Color" \
##            -helpstr "Change the Background Color" \
##            -command {pick_bgcolor}
        command fontset -label "Change Font" \
            -helpstr "Change the Font" \
            -command {pick_font}
        command printgame -label "Print Game" \
            -helpstr "Print the Current Board" \
            -command {sdk_print}
    }
    menubutton stim -text "About" -menu {
        options -tearoff false
        command aboutme -label "About Me" \
            -helpstr "About This Sudoku Application" \
            -command {about_msg "Sudoku Puzzle Game\n Written in tcl/tk\n\
                               Version $s_version\nBy Sckoarn"}
        command sudokurules -label "Help and Rules" \
            -helpstr "Game info and Rules" \
            -command {show_rules}
        command sudokustats -label "Player Stats" \
            -helpstr "Player Game Records" \
            -command {show_stats}
    }
}]
##  pack the menu bar
pack $mbar -side left
$mbar configure -pady 0

pack $menu_frame -fill x -pady 4





pack $e::i11 $e::i12 $e::i13 $e::i14 $e::i15 $e::i16 $e::i17 $e::i18 $e::i19 -side left
pack $f10 $f11 $f12
pack $e::i21 $e::i22 $e::i23 $e::i24 $e::i25 $e::i26 $e::i27 $e::i28 $e::i29 -side left
pack $f20 $f21 $f22
pack $e::i31 $e::i32 $e::i33 $e::i34 $e::i35 $e::i36 $e::i37 $e::i38 $e::i39 -side left
pack $f30 $f31 $f32
pack $f1 -side left
pack $f2 -side left -padx 4
pack $f3 -side left

pack $r1 -padx 14

pack $e::i41 $e::i42 $e::i43 $e::i44 $e::i45 $e::i46 $e::i47 $e::i48 $e::i49 -side left
pack $f40 $f41 $f42
pack $e::i51 $e::i52 $e::i53 $e::i54 $e::i55 $e::i56 $e::i57 $e::i58 $e::i59 -side left
pack $f50 $f51 $f52
pack $e::i61 $e::i62 $e::i63 $e::i64 $e::i65 $e::i66 $e::i67 $e::i68 $e::i69 -side left
pack $f60 $f61 $f62
pack $f4 -side left
pack $f5 -side left -padx 4
pack $f6 -side left

pack $r2 -pady 4 -padx 14

pack $e::i71 $e::i72 $e::i73 $e::i74 $e::i75 $e::i76 $e::i77 $e::i78 $e::i79 -side left
pack $f70 $f71 $f72
pack $e::i81 $e::i82 $e::i83 $e::i84 $e::i85 $e::i86 $e::i87 $e::i88 $e::i89 -side left
pack $f80 $f81 $f82
pack $e::i91 $e::i92 $e::i93 $e::i94 $e::i95 $e::i96 $e::i97 $e::i98 $e::i99 -side left
pack $f90 $f91 $f92
pack $f7 -side left
pack $f8 -side left -padx 4
pack $f9 -side left

pack $r3 -padx 14

##tk_focusFollowsMouse;


############################################
##  return the pointer based on row and col
proc get_ptr {rc} {
    
    switch $rc {
        "11" {set active $e::i11}
        "12" {set active $e::i12}
        "13" {set active $e::i13}
        "14" {set active $e::i14}
        "15" {set active $e::i15}
        "16" {set active $e::i16}
        "17" {set active $e::i17}
        "18" {set active $e::i18}
        "19" {set active $e::i19}
        "21" {set active $e::i21}
        "22" {set active $e::i22}
        "23" {set active $e::i23}
        "24" {set active $e::i24}
        "25" {set active $e::i25}
        "26" {set active $e::i26}
        "27" {set active $e::i27}
        "28" {set active $e::i28}
        "29" {set active $e::i29}
        "31" {set active $e::i31}
        "32" {set active $e::i32}
        "33" {set active $e::i33}
        "34" {set active $e::i34}
        "35" {set active $e::i35}
        "36" {set active $e::i36}
        "37" {set active $e::i37}
        "38" {set active $e::i38}
        "39" {set active $e::i39}
        "41" {set active $e::i41}
        "42" {set active $e::i42}
        "43" {set active $e::i43}
        "44" {set active $e::i44}
        "45" {set active $e::i45}
        "46" {set active $e::i46}
        "47" {set active $e::i47}
        "48" {set active $e::i48}
        "49" {set active $e::i49}
        "51" {set active $e::i51}
        "52" {set active $e::i52}
        "53" {set active $e::i53}
        "54" {set active $e::i54}
        "55" {set active $e::i55}
        "56" {set active $e::i56}
        "57" {set active $e::i57}
        "58" {set active $e::i58}
        "59" {set active $e::i59}
        "61" {set active $e::i61}
        "62" {set active $e::i62}
        "63" {set active $e::i63}
        "64" {set active $e::i64}
        "65" {set active $e::i65}
        "66" {set active $e::i66}
        "67" {set active $e::i67}
        "68" {set active $e::i68}
        "69" {set active $e::i69}
        "71" {set active $e::i71}
        "72" {set active $e::i72}
        "73" {set active $e::i73}
        "74" {set active $e::i74}
        "75" {set active $e::i75}
        "76" {set active $e::i76}
        "77" {set active $e::i77}
        "78" {set active $e::i78}
        "79" {set active $e::i79}
        "81" {set active $e::i81}
        "82" {set active $e::i82}
        "83" {set active $e::i83}
        "84" {set active $e::i84}
        "85" {set active $e::i85}
        "86" {set active $e::i86}
        "87" {set active $e::i87}
        "88" {set active $e::i88}
        "89" {set active $e::i89}
        "91" {set active $e::i91}
        "92" {set active $e::i92}
        "93" {set active $e::i93}
        "94" {set active $e::i94}
        "95" {set active $e::i95}
        "96" {set active $e::i96}
        "97" {set active $e::i97}
        "98" {set active $e::i98}
        "99" {set active $e::i99}
        default {}
    }
    return $active        
}

###################################
##  show the Hyper text window
proc show_rules {} {
    global hlp_win

    ## check see if help win exists
    set rtn [winfo exists .rls]
    ## if not create it
    if {$rtn == 0} {
        set hlp_win [iwidgets::hyperhelp .rls -title "Help & Rules & Stats" -modality none \
            -topics {Rules Guide Stats} -helpdir . ]
    }
    $hlp_win showtopic rules
    $hlp_win activate
}
###  pick a color proc
proc pick_color {} {
    global dis_col
    set tem_col [tk_chooseColor -initialcolor $dis_col -title "Choose Color"]
    if {$dis_col != ""} {
        set dis_col $tem_col
        color_init
    }
}
###  pick and change font
proc pick_font {} {
    global fsize
    
##  choosefont "Courier 10 italic" "new font"
    set fnt [choosefont brd_fnt "new font"]
    
    #$ent1 configure -font $fnt
    #dbg_msg "$fnt"
    
    for {set j 1} {$j < 10} {incr j} {
        for {set i 1} {$i < 10} {incr i} {
            set loc $j
            append loc $i
            set ptr [get_ptr $loc]
            #dbg_msg $ptr
            $ptr configure -font $fnt
            #$ptr delete 0 end
        }
    }
    
}


###  pick a color proc
proc pick_bgcolor {} {
    
    set tem_col [tk_chooseColor -initialcolor gray50 -title "Choose Color"]
    if {$tem_col != ""} {
        . configure -bg $tem_col
        
        #for {set j 1} {$j < 10} {incr j} {
        #    for {set i 1} {$i < 10} {incr i} {
        #        set loc $j
        #        append loc $i
        #        set ptr [get_ptr $loc]
        #        #dbg_msg $ptr
        #        #$ptr configure -fg $tem_col
        #        #$ptr delete 0 end
        #    }
        #}
    }
}
##  show stats proc
proc show_stats {} {
    global hlp_win
    ## check see if help win exists
    set rtn [winfo exists .rls]
    ## if not create it
    if {$rtn == 0} {
        set hlp_win [iwidgets::hyperhelp .rls -title "Help & Rules & Stats" -modality none \
            -topics {Rules Guide Stats} -helpdir . ]
    }
    $hlp_win showtopic stats
    $hlp_win activate
}
#############################################
#  update back ground color
proc color_init {} {
    
    global dis_col
    
    for {set j 1} {$j < 10} {incr j} {
        for {set i 1} {$i < 10} {incr i} {
            set loc $j
            append loc $i
            set ptr [get_ptr $loc]
            #dbg_msg $ptr
            $ptr configure -readonlybackground $dis_col
            #$ptr delete 0 end
        }
    }
}
#############################################
#  Proc to initialize the board,  clear it
proc board_init {} {
    for {set j 1} {$j < 10} {incr j} {
        for {set i 1} {$i < 10} {incr i} {
            set loc $j
            append loc $i
            set ptr [get_ptr $loc]
            #dbg_msg $ptr
            $ptr configure -state normal
            $ptr delete 0 end
        }
    }
}
############################################
##  Make the active entry
proc make_active {} {
    
    #namespace import e::*
    
    set rc $e::row
    append rc $e::col
    set active ""
    switch $rc {
        "11" {set active $e::i11}
        "12" {set active $e::i12}
        "13" {set active $e::i13}
        "14" {set active $e::i14}
        "15" {set active $e::i15}
        "16" {set active $e::i16}
        "17" {set active $e::i17}
        "18" {set active $e::i18}
        "19" {set active $e::i19}
        "21" {set active $e::i21}
        "22" {set active $e::i22}
        "23" {set active $e::i23}
        "24" {set active $e::i24}
        "25" {set active $e::i25}
        "26" {set active $e::i26}
        "27" {set active $e::i27}
        "28" {set active $e::i28}
        "29" {set active $e::i29}
        "31" {set active $e::i31}
        "32" {set active $e::i32}
        "33" {set active $e::i33}
        "34" {set active $e::i34}
        "35" {set active $e::i35}
        "36" {set active $e::i36}
        "37" {set active $e::i37}
        "38" {set active $e::i38}
        "39" {set active $e::i39}
        "41" {set active $e::i41}
        "42" {set active $e::i42}
        "43" {set active $e::i43}
        "44" {set active $e::i44}
        "45" {set active $e::i45}
        "46" {set active $e::i46}
        "47" {set active $e::i47}
        "48" {set active $e::i48}
        "49" {set active $e::i49}
        "51" {set active $e::i51}
        "52" {set active $e::i52}
        "53" {set active $e::i53}
        "54" {set active $e::i54}
        "55" {set active $e::i55}
        "56" {set active $e::i56}
        "57" {set active $e::i57}
        "58" {set active $e::i58}
        "59" {set active $e::i59}
        "61" {set active $e::i61}
        "62" {set active $e::i62}
        "63" {set active $e::i63}
        "64" {set active $e::i64}
        "65" {set active $e::i65}
        "66" {set active $e::i66}
        "67" {set active $e::i67}
        "68" {set active $e::i68}
        "69" {set active $e::i69}
        "71" {set active $e::i71}
        "72" {set active $e::i72}
        "73" {set active $e::i73}
        "74" {set active $e::i74}
        "75" {set active $e::i75}
        "76" {set active $e::i76}
        "77" {set active $e::i77}
        "78" {set active $e::i78}
        "79" {set active $e::i79}
        "81" {set active $e::i81}
        "82" {set active $e::i82}
        "83" {set active $e::i83}
        "84" {set active $e::i84}
        "85" {set active $e::i85}
        "86" {set active $e::i86}
        "87" {set active $e::i87}
        "88" {set active $e::i88}
        "89" {set active $e::i89}
        "91" {set active $e::i91}
        "92" {set active $e::i92}
        "93" {set active $e::i93}
        "94" {set active $e::i94}
        "95" {set active $e::i95}
        "96" {set active $e::i96}
        "97" {set active $e::i97}
        "98" {set active $e::i98}
        "99" {set active $e::i99}
        default {}
    }
    focus $active
    $active selection range 0 end
        
}

###############################################
##  Check for valid entry
proc check_ent {ent} {
    set rtn 1
    
    set cur [$ent get]
    set len [string length $cur]
    if {$len > 1} {
        set rtn 0
    }
    set dig [string is digit $cur]
    if {$dig != 1} {
        set rtn 0
    }
    if {$cur == "0"} {
        set rtn 0
    }
    #puts $cur
    time_update
    return $rtn
}
#############################################
##  Deal with the invalid entries
proc inval_ent {ent} {
    
    set cur [$ent get]
    set len [string length $cur]
    if {$len > 1} {
        set cur [string range $cur 0 0]
    }
    set dig [string is digit $cur]
    if {$dig != 1 | $cur == "0"} {
        $ent delete 0 end
    } else {
        $ent delete 0 end
        $ent insert 0 $cur
    }
    
}

