##-------------------------------------------------------------------------------
##--                            Ken Campbell
##--                        No Rights Reserved
##-------------------------------------------------------------------------------
##-- $Author: ken $
##--
##-- $Date: 2005/12/09 15:14:08 $
##--
##-- $Name:  $
##--
##-- $Id: $
##--
##-- $Source: $
##--
##-- Description :
##--      
##------------------------------------------------------------------------------
##-- This software contains concepts 
##--  
##-- 
##-------------------------------------------------------------------------------
## package requires
package require Iwidgets 4.0

### Create an index table to all TCL procedures in all scripts
#auto_mkindex . *.tcl
#lappend auto_path {.}

## set the tool version (not CVS version)
set s_version "v1.0"
## get the time and date from the system
set raw_date [clock scan now]
set scan_date [clock format $raw_date -format "%d %b %Y %T"]

## window title
wm title . "Sudoku"


set fsize 16
# background color of readonly entry wids
set dis_col LightBlue
font create brd_fnt -family Arial -size 16
font create bline -family Times -size 10 -weight bold
font create shwn -family Arial -size 36


#####################
##  Game limits
set mx_gamenum 2084
set pcanvs {}
array unset blocked
set tries 0

file delete "test_log.txt"
set logfn ""


##  Layout related code
source layout.tcl
##  events and handlers
source events.tcl
##  generation procs
source gen_procs.tcl
##  font selection
source font_sel.tcl
namespace import ::choosefont::choosefont
source print_proc.tcl
##source solve_advance.tcl


##  valid or shown numbers lists
set vrow_v1 {0 0 0 0 0 0 0 0 0}
set vrow_v2 {0 0 0 0 0 0 0 0 0}
set vrow_v3 {0 0 0 0 0 0 0 0 0}
set vrow_v4 {0 0 0 0 0 0 0 0 0}
set vrow_v5 {0 0 0 0 0 0 0 0 0}
set vrow_v6 {0 0 0 0 0 0 0 0 0}
set vrow_v7 {0 0 0 0 0 0 0 0 0}
set vrow_v8 {0 0 0 0 0 0 0 0 0}
set vrow_v9 {0 0 0 0 0 0 0 0 0}

##  Row values
set row_v1 {0 0 0 0 0 0 0 0 0}
set row_v2 {0 0 0 0 0 0 0 0 0}
set row_v3 {0 0 0 0 0 0 0 0 0}
set row_v4 {0 0 0 0 0 0 0 0 0}
set row_v5 {0 0 0 0 0 0 0 0 0}
set row_v6 {0 0 0 0 0 0 0 0 0}
set row_v7 {0 0 0 0 0 0 0 0 0}
set row_v8 {0 0 0 0 0 0 0 0 0}
set row_v9 {0 0 0 0 0 0 0 0 0}
##  colum values
set col_v1 {0 0 0 0 0 0 0 0 0}
set col_v2 {0 0 0 0 0 0 0 0 0}
set col_v3 {0 0 0 0 0 0 0 0 0}
set col_v4 {0 0 0 0 0 0 0 0 0}
set col_v5 {0 0 0 0 0 0 0 0 0}
set col_v6 {0 0 0 0 0 0 0 0 0}
set col_v7 {0 0 0 0 0 0 0 0 0}
set col_v8 {0 0 0 0 0 0 0 0 0}
set col_v9 {0 0 0 0 0 0 0 0 0}
#  Box vaues
#
#     box1  box2  box3
#     box4  box5  box6
#     box7  box8  box9
#
# box1 = row_v1(0-2)
# box1 = row_v2(0-2)
# box1 = row_v3(0-2)
set box1 {0 0 0 0 0 0 0 0 0}
set box2 {0 0 0 0 0 0 0 0 0}
set box3 {0 0 0 0 0 0 0 0 0}
set box4 {0 0 0 0 0 0 0 0 0}
set box5 {0 0 0 0 0 0 0 0 0}
set box6 {0 0 0 0 0 0 0 0 0}
set box7 {0 0 0 0 0 0 0 0 0}
set box8 {0 0 0 0 0 0 0 0 0}
set box9 {0 0 0 0 0 0 0 0 0}

##  set a tries to gen max count
set try_cnt 64
set effort_level 2500
##  make active entry wid 
make_active

##  Set timer off and time to zero
set tm_on 0
set start_time 0
##  frame for timer texts
set tfr [frame .tmfr]
set lab1 [label $tfr.lb1 -text "" -textvariable lb1_text]
set timer_txt [label $tfr.lb2 -text "" -textvariable tm_txt]
pack $lab1 -side left
pack $timer_txt -side right
pack $tfr -fill x -pady 5

# start up the timer update process
set e_time 18000
::every::schedule 1000 time_update
# create frame for controls
set cfr [frame .cfra]
## create the range list
set rng {}
lappend rng 1 $mx_gamenum
## spin int for game number selection
set gnumb [iwidgets::spinint $cfr.ent1 -labeltext "Game Number" -width 4 -range $rng]
##  option menue for level of play
set glevel [iwidgets::optionmenu $cfr.men1 -labeltext "Level"]
$glevel insert 0 1 2 3 4 5 6 7
pack $gnumb $glevel
$glevel select 0
## frame for buttons
set butfr [frame $cfr.butf]
##  Buttons
set start_g [button $butfr.but1 -text "Start" -command {start_game 0}]
#set start_g [button $butfr.but1 -text "Start" -command {test_gens}]
##set start_g [button $butfr.but1 -text "Start" -command {test_gens}]
set end_g [button $butfr.but2 -text "Finish" -command {stop_game 0}]
pack $start_g -side left 
pack $end_g -side right
pack $butfr -fill x
pack $cfr
## user message text label
set user_msg [label .lb3 -text "Welcome" -textvariable usr_txt]
pack $user_msg -side left

## wid for checking wheather to procced while game is running
iwidgets::messagedialog .md -title "Restart Game" -modality application \
    -bitmap questhead -text "This action will end the Current Game. \n Continue?"
.md hide Help
.md buttonconfigure OK -text "Yes"
.md buttonconfigure Cancel -text "No"


######################
#  Proc used to test generation.
proc test_gens {} {
    global row_v1 row_v2 row_v3 row_v4 row_v5 row_v6 row_v7 row_v8 row_v9
    global col_v1 col_v2 col_v3 col_v4 col_v5 col_v6 col_v7 col_v8 col_v9
    global gnumb glevel mx_gamenum logfn

    for {set i 1} {$i <= $mx_gamenum} {incr i} {
	    
        set logfn [open "test_log.txt" a]
        
        $gnumb delete 0 end
        $gnumb insert 0 $i
        set chk [generate 0]
        if {$chk == 1} {
            puts "Successful generation of number $i."
            #puts "row1:  $row_v1"
            #puts "row2:  $row_v2"
            #puts "row3:  $row_v3"
            #puts "row4:  $row_v4"
            #puts "row5:  $row_v5"
            #puts "row6:  $row_v6"
            #puts "row7:  $row_v7"
            #puts "row8:  $row_v8"
            #puts "row9:  $row_v9"
            #puts "col1:  $col_v1"
            #puts "col2:  $col_v2"
            #puts "col3:  $col_v3"
            #puts "col4:  $col_v4"
            #puts "col5:  $col_v5"
            #puts "col6:  $col_v6"
            #puts "col7:  $col_v7"
            #puts "col8:  $col_v8"
            #puts "col9:  $col_v9"
        } else {
            puts "ERROR:  Generation Failed on number $i!!!"
            dbg_msg "Error in $i"
        }
        update
        
	    puts $logfn "Game number $i"
        
        for {set j 0} {$j < 6} {incr j} {
	        $glevel select $j
	        
            set grtn [gen_shown 3 0]
	        
            if {$grtn == 1} {
                #set logfn [open "test_log.txt" a]
                set l [expr {$j + 1}]
	            puts "Failed game number: $i  at level:  $l"
	            puts $logfn "Failed game number: $i  at level:  $l"
	            
            }
        }
        
        close $logfn
    }
    
}

